<?php

/*
* Librairie d'envoi SMS, SMS Linker.
* Cette librairie nécessite PHP 5 ainsi que la librairie cURL 
* N'oubliez pas d'éditer le fichier smslinker.config.php avant de l'utiliser
* L'utilisation de cette librairie nécessite une inscription (gratuite) préalable sur le site https://smlinker.com ainsi que des crédits SMS.
* @package pagepackage
*/
require_once("smslinker.config.php");



/*
* Classe SMSLinker à instancier et utiliser pour communiquer avec le serveur SMSLinker.com
* @package SMSLinker
* @author Société ADDREA <contact@addrea.fr>
* @copyright SMSLinker.com
*/
class SMSLinker {


	/**
	* URL de base NE PAS MODIFIER
	* @access private
	* @var string
	*/
	private $urlbase = "https://api.smslinker.com/api/";

	/**
	* Résultat Brut
	* @access public
	* @var object
	*/
	public $rawresult;

	/**
	* Résultat
	* @access public
	* @var object
	*/
	public $result;

	public function __construct() {
		function iscurlinstalled() {
			if(in_array('curl', get_loaded_extensions())) {
				return true;
			} else {
				return false;
			}
		}
		
		if(!iscurlinstalled()) die("L'API SMS Linker NECESSITE L'INSTALLATION DE CURL");
		if(APIKEY == '' || APIKEY == "APIKEY_00000000000000000000000000000000") die('Vous devez configurer le fichier smslinker.config.php');
	}

	/**
	* Requéte cURL - Vous n'êtes pas sensé appeler cette méthode
	* @access private
	* 
	*/
	private function _postRequest($url,$fields) {
		$fields['cle'] = APIKEY;
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_HEADER, 0);
		curl_setopt($curl, CURLOPT_URL, $this->urlbase.$url);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 0);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_TIMEOUT, 10);
		curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($fields));
		$result = curl_exec ($curl);
		curl_close ($curl);
		return $result;
	}

	/**
	* Fonction d'envoi de SMS pour votre compte principal
    * @param integer product_id : Produit utilisé pour cet envoi, par default premium
    * @param string senderlabel : sender name ( if SMS premium or SMS International)
    * @param string content : contenu du message
    * @param string manual_recipients : list de destinataires séparés par des virgules
    * @param integer phonebooks : ID du repertoire à utiliser (Optional)
    * @param integer country_id (optional) : si envoi international, vous devez spécifier un pays
    * @param boolean dynamicvars (optional) : 1 = Active les variables dynamiques de votre repertoire ,par default, c'est désactivé. /!\ SI VOUS ACTIVEZ, LES DESTINATAIRES MANUELS SERONT IGNORES /!\
	* @param string senddate (optional) : date d'envoi au format (YYYY-mm-dd_H:i)						
    * @param integer richtype (optional) : Type 1 = Rich SMS, Type 2 = Minisite, Type 3 = Enquete (Survey)
	* @param boolean richurlconf (optional) : 0 = une url pour tous vos destinataires, 1 = une url par destinataire
	* @param string richurlorigin (optional) : Si le parametre richurlconf est à 1, vous pouvez définir une URL personnalisée
    * @param string destination_url (optional) : Si votre sms est un sms enrichi il vous faudra spécifier l'url de destination de l'url raccourci					
	* @param integer minisite_id (optional) : Si votre sms enrichi est un minisite, spécifiez l'id de votre minisite						
	 *@param integer survey_id (optional) : SI votre sms enrichi est une enquete, spécifiez l'id de votre enquete
	*/
	public function sendSMS($product_id = 1, $senderlabel = null, $content = null, $manual_recipients = null, $phonebooks = null, $country_id = null, $dynamicvars = null, $senddate = null, $richtype = null, $richurlconf = null, $richurlorigin = null, $destination_url = null, $minisite_id = null, $survey_id = null) {
		$argsposts = array(
			"product_id" => $product_id,
			"senderlabel" => $senderlabel,
			"content" => $content,
			"manual_recipients" => $manual_recipients,
			"phonebooks" => $phonebooks,
			"country_id" => $country_id,
			"dynamicvars" => $dynamicvars,
			"senddate" => $senddate,
			"richtype" => $richtype,
			"richurlconf" => $richurlconf,
			"richurlorigin" => $richurlorigin,
			"destination_url" => $destination_url,
			"minisite_id" => $minisite_id,
			"survey_id" => $survey_id
		);
		$this->rawresult = $this->_postRequest("message/send", $argsposts);

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des envois du compte
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaigns($limitation = null, $page = null) {
		$argsposts = array(
			"limitation" = $limitation,
			"page" => $page
		);
		$this->rawresult = $this->_postRequest("campaigns", $argsposts);

		return $this->rawresult;
	}

	/**
	* Fonction des infos d'un envoi du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaign($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("campaign/". $ID ."/informations", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}
		

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des destinataires d'un envoi du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaignRecipients($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("campaign/". $ID ."/informations/recipients", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des stops d'un envoi du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaignStops($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("campaign/". $ID ."/informations/stops", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}
	
	/**
	* Fonction de récupération des stats (résumé) d'un envoi du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaignStatsBrief($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("campaign/". $ID ."/stats/brief", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des stats (details) d'un envoi du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaignStatsDetails($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("campaign/". $ID ."/stats/details", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}	

	/**
	* Fonction de récupération des reponses d'un envoi du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaignAnswers($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("campaign/". $ID ."/informations/answers", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des accusés de reception d'un envoi du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCampaignDreceipts($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("campaign/". $ID ."/informations/dreceipts", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des stops du compte
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getStops() {
		$this->rawresult = $this->_postRequest("account/stops",array());
		$this->result = $this->rawresult;
		return $this->rawresult;
	}

	/**
	* Fonction de récupération des minisites du compte
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getMinisites() {
		$this->rawresult = $this->_postRequest("account/minisites", array());

		return $this->rawresult;
	}	

	/**
	* Fonction de récupération des enquetes du compte
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getSurveys() {
		$this->rawresult = $this->_postRequest("account/surveys", array());

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des réponses d'une enquete du compte
	* Resultat sous format JSON 
	* @param integer $ID Identifiant de la campagne	
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getSurveyAnswers($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("account/survey/". $ID ."/answers", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des credits du compte
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCredits() {
		$this->rawresult = $this->_postRequest("credits", array());

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des informations de la marque blanche du compte
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getWhitelabel() {
		$this->rawresult = $this->_postRequest("whitelabel", array());

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des produits par smslinker
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getProducts() {
		$this->rawresult = $this->_postRequest("products", array());

		return $this->rawresult;
	}	

	/**
	* Fonction de récupération des pays couverts par smslinker
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getCountries() {
		$this->rawresult = $this->_postRequest("countries", array());

		return $this->rawresult;
	}

	/**
	* Fonction de récupération des repertoires par smslinker
	* Resultat sous format JSON 
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getPhonebooks() {
		$this->rawresult = $this->_postRequest("phonebooks", array());

		return $this->rawresult;
	}

	/**
	* Fonction des contact d'un repertoire smslinker
	* Resultat sous format JSON 
	* @param integer $ID Identifiant du repertoire
	* Documentation complete https://api.smslinker.com/php
	*/
	public function getPhonebookContacts($ID = null) {
		if($ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("phonebook/". $ID ."/contacts", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}

	/**
	* Fonction des contact d'un repertoire smslinker
	* Resultat sous format JSON 
	* @param integer $PID Identifiant du repertoire
	* @param integer $ID Identifiant du contact
	* Documentation complete https://api.smslinker.com/php
	*/
	public function delPhonebookContact($ID = null, $PID = null) {
		if($PID != null && is_numeric($PID) && $ID != null && is_numeric($ID)) {
			$this->rawresult = $this->_postRequest("phonebook/". $PID ."/contact/". $ID ."/delete", array());
		} else {
			$this->rawresult = '{"ERROR":"ID_MUST_BE_INTEGER"}';
		}

		return $this->rawresult;
	}

	/**
	* Fonction d'ajout d'un stop au compte
	* Resultat sous format JSON 
	* @param string $Phonenumber Numéro de téléphone du stop
	* Documentation complete https://api.smslinker.com/php
	*/
	public function createStop($Phonenumber = null) {
		if($Phonenumber != null) {
			$this->rawresult = $this->_postRequest("stop/create", array('Phonenumber' => $Phonenumber));
		} else {
			$this->rawresult = '{"ERROR":"PHONENUMBER_NOT_SPECIFIED"}';
		}

		return $this->rawresult;
	}

}
?>